<?php

class EWRporta_DataWriter_History extends XenForo_DataWriter
{
	protected $_existingDataErrorPhrase = 'requested_page_not_found';

	protected function _getFields()
	{
		return array(
			'EWRporta_history' => array(
				'page_id'			=> array('type' => self::TYPE_UINT, 'required' => true),
				'user_id'			=> array('type' => self::TYPE_UINT, 'required' => true),
				'username'			=> array('type' => self::TYPE_STRING, 'required' => true),
				'history_id'		=> array('type' => self::TYPE_UINT, 'autoIncrement' => true),
				'history_date'		=> array('type' => self::TYPE_UINT, 'required' => true),
				'history_type'		=> array('type' => self::TYPE_STRING, 'required' => true,
					'allowedValues' => array('bbcode', 'html', 'phpfile')
				),
				'history_content'	=> array('type' => self::TYPE_STRING, 'required' => true),
				'history_current'	=> array('type' => self::TYPE_UINT, 'required' => true),
			)
		);
	}

	protected function _getExistingData($data)
	{
		if (!$historyID = $this->_getExistingPrimaryKey($data))
		{
			return false;
		}

		return array('EWRporta_pages' => $this->getModelFromCache('EWRporta_Model_History')->getHistoryByID($historyID));
	}

	protected function _getUpdateCondition($tableName)
	{
		return false;
	}

	protected function _preSave()
	{
		$visitor = XenForo_Visitor::getInstance();

		$this->set('user_id', $visitor['user_id']);
		$this->set('username', $visitor['username']);
	}
}